import { Injectable } from '@angular/core'
import { Response, Headers, Http } from '@angular/http'

import { Observable } from 'rxjs/Observable'

import 'rxjs/add/operator/map'
import 'rxjs/add/operator/catch'
import 'rxjs/add/operator/toPromise'
import 'rxjs/add/observable/fromPromise'

import { LocalConfig } from './local-config'

import { IdGen } from '../database/idgen'
import { MemoryDbVariableMode,
        MemoryDbLocalStorageMode,
        MemoryDb
      } from '../database/memorydb'

@Injectable()
export class ConfigApiService {
    private url: string
    private provider: MemoryDb

    private handleError(error: any): Promise<any> {
        console.error('An error occurred', error)
        error = error.message || JSON.parse(error._body) || error
        if (error.error) {
            error = error.error
        }
        return Promise.reject(error)
    }

    private headers = new Headers({ 'Content-Type': 'application/json', 'X-Key': '12345', 'X-UserId': 'uiuser01' })

    constructor(
        private http: Http
    ) {
        this.url = LocalConfig.ApiServer + '/api/config'
        if (LocalConfig.DataProvider !== "http") {
            this.provider = new MemoryDb(LocalConfig.DataProvider === "LocalStorage" ? new MemoryDbLocalStorageMode() : new MemoryDbVariableMode())
            this.provider.insert('config', 'LogLevel', { value: LocalConfig.Defaults.LogLevel })
            this.provider.insert('config', 'SecondsForExternalRedirect', { value: LocalConfig.Defaults.SecondsForExternalRedirect })
            // this.provider.insert('config', 'ApiServer', { value: LocalConfig.Defaults.ApiServer })
            this.provider.insert('config', 'LocalDomains', { value: LocalConfig.Defaults.LocalDomains })
            this.provider.insert('config', '_TestNumericValue', { value: 42 })
            this.provider.insert('config', '_TestArrayValue', { value: [1, 2, 3, 4] })
        }
    }

    update(name: string, value: any): Promise<Response> {
        // console.log(`ConfigApiService::update|name:${name}|value:${value}`)
        if (LocalConfig.DataProvider !== "http") {
            return new Promise((resolve, reject) => {
                this.provider.insert("config", name, { value })
                    .then(() => {
                        resolve()
                    })
            })
        }
        else {
            return this.http.put(this.url + '/' + name, { value }, { headers: this.headers })
                .toPromise()
        }
    }

    get(name: string): any {
        // console.log(`ConfigApiService::get|name:${name}`)
        if (LocalConfig.DataProvider !== "http") {
            return new Promise((resolve, reject) => {
                this.provider.get("config", name)
                    .then(item => {
                        resolve(item.value)
                    })
            })
        }
        else {
            return this.http.get(this.url + '/' + name, { headers: this.headers })
                .map(response => response.text())
                .catch(this.handleError)
        }
    }
}
